/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Actiongram {
    private final List<Action> actions;
    private final String name;
    public static final String DEFAULT_NAME = "";
    private static final DefaultComparator DEFAULT_COMPARATOR = new DefaultComparator();

    public Actiongram(List<Action> actions, String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.actions = Collections.unmodifiableList(Preconditions.checkNotNull(actions, "actions"));
        for (Action a : actions) {
            Preconditions.checkArgument(a.isMainLocalAlt(), "%s is not MLA in actiongram %s", (Object)a, (Object)name);
        }
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Action getActionByName(String name) {
        for (Action action : this.actions) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return null;
    }

    public Action getRootAction() {
        return this.actions.get(this.actions.size() - 1);
    }

    public String getName() {
        return this.name;
    }

    public long getTimeToMake(double qty) {
        return this.getTimeToMake(Collections.nCopies(this.actions.size(), qty));
    }

    public long getTimeToMake(double qty, boolean includePrepareTime) {
        return this.getTimeToMake(Collections.nCopies(this.actions.size(), qty), includePrepareTime);
    }

    @Deprecated
    public long getTimeToMake(List<Double> qties) {
        return this.getTimeToMake(qties, false);
    }

    @Deprecated
    public long getTimeToMake(List<Double> qties, boolean includePrepareTime) {
        if (qties.size() != this.actions.size()) {
            throw new IllegalArgumentException("Qties must be of the same size as the actiongram.");
        }
        long res = 0L;
        for (int i = 0; i < this.actions.size(); ++i) {
            double qty = qties.get(i);
            Action a = this.actions.get(i);
            res = LongMath.checkedAdd(res, a.timeToMake(qty));
            if (!includePrepareTime || !(qty > 1.0E-7)) continue;
            res = LongMath.checkedAdd(res, a.getMinTimeToPrepare());
        }
        return res;
    }

    public long getNormtime(double qty) {
        long res = 0L;
        for (Action a : this.actions) {
            res += a.normtime(qty);
        }
        return res;
    }

    @Deprecated
    public long getNormtime(double[] qties) {
        if (qties.length != this.actions.size()) {
            throw new IllegalArgumentException("Qties must be of the same size as the actiongram.");
        }
        long res = 0L;
        for (int i = 0; i < this.actions.size(); ++i) {
            double qty = qties[i];
            Action a = this.actions.get(i);
            res += a.normtime(qty);
        }
        return res;
    }

    public int getActionOrder(Action act) {
        if (!this.actions.contains(act)) {
            throw new IllegalArgumentException("Invalid action " + act);
        }
        return this.actions.indexOf(act);
    }

    public Action getPrecedingAction(Action act) {
        int actionOrder = this.getActionOrder(act);
        Action predecessor = actionOrder == 0 ? null : this.actions.get(actionOrder - 1);
        return predecessor;
    }

    public double getMaterialQty(Material material) {
        double qty = 0.0;
        for (Action a : this.actions) {
            if (!a.getBom().materials().contains(material)) continue;
            if (material.isConstant()) {
                qty += a.getBom().getQty(material);
                continue;
            }
            qty += a.getBom().getQty(material) * a.getQtyCoef();
        }
        return qty;
    }

    public double getProducingQty(Material material) {
        double qty = 0.0;
        for (Action a : this.actions) {
            for (MaterialQuantity mq : a.getProduces()) {
                if (mq.getMaterial() != material) continue;
                if (material.isConstant()) {
                    qty += mq.getQty();
                    continue;
                }
                qty += mq.getQty() * a.getQtyCoef();
            }
        }
        return qty;
    }

    public MaterialQuantity getProdItem(Material material) {
        for (Action a : this.actions) {
            for (MaterialQuantity pi : a.getProduces()) {
                if (pi.getMaterial() != material) continue;
                return pi;
            }
        }
        return null;
    }

    public Set<Material> getMaterials() {
        HashSet<Material> mats = Sets.newHashSet();
        for (Action a : this.getActions()) {
            mats.addAll(a.getBom().materials());
        }
        return mats;
    }

    public String toString() {
        return String.format("Actiongram '%s'", this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Actiongram)) {
            return false;
        }
        Actiongram that = (Actiongram)o;
        return this.actions.equals(that.actions) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.actions);
    }

    public static Comparator<Actiongram> defaultComparator() {
        return DEFAULT_COMPARATOR;
    }

    private static class DefaultComparator
    extends Ordering<Actiongram> {
        static final String FIRST_AG_NAME = "*";

        private DefaultComparator() {
        }

        @Override
        public int compare(Actiongram o1, Actiongram o2) {
            if (o1.getName().equals(FIRST_AG_NAME)) {
                if (o2.getName().equals(FIRST_AG_NAME)) {
                    return 0;
                }
                return -1;
            }
            if (o2.getName().equals(FIRST_AG_NAME)) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

